/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container;

import java.security.SecureRandom;

public class UuidFactoryFast {
    private static UuidFactoryFast instance = new UuidFactoryFast();
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static int sequenceNumber = new SecureRandom().nextInt();

    private UuidFactoryFast() {
    }

    public String create() {
        long timestamp = System.currentTimeMillis();
        byte[] uuidBytes = new byte[9];
        UuidFactoryFast.putLong(uuidBytes, timestamp, 0, 6);
        UuidFactoryFast.putLong(uuidBytes, UuidFactoryFast.getSequenceNumber(), 6, 3);
        return UuidFactoryFast.byteArrayToHex(uuidBytes);
    }

    public static UuidFactoryFast getInstance() {
        return instance;
    }

    private static int getSequenceNumber() {
        return sequenceNumber++;
    }

    private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
        for (int i = 0; i < numberOfLongBytes; ++i) {
            array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
        }
    }

    public static String byteArrayToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

